//
//  OPSyncSource.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-05-17.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPDatabaseObject.h"

extern NSString *OPSyncSourceLocationDocuments;
extern NSString *OPSyncSourceLocationDropbox;
extern NSString *OPSyncSourceLocationUbiquity;
extern NSString *OPSyncSourceLocationImport;

@class OPSyncState;

@interface OPSyncSource : OPDatabaseObject

@property (nonatomic, readonly) NSString * localizedTitle;
@property (nonatomic, readonly) OPImage * icon;

@property (nonatomic, readonly) BOOL legacySyncSource;

// database properties
@property (nonatomic, copy) NSString * keychainIdentifier;
@property (nonatomic, copy) NSString * keychainType;

@property (nonatomic, strong) NSString * remoteProfileUUID;
@property (nonatomic) OPTimestamp remoteProfileTimestamp;
@property (nonatomic, strong) NSData * remoteProfileAttributesEncryptedWithLocal;

@property (nonatomic, strong) NSString * localProfileUUID;
@property (nonatomic) OPTimestamp localProfileTimestamp;
@property (nonatomic, strong) NSData * localProfileAttributesEncryptedWithRemote;

// collections

@property (nonatomic) NSSet * itemStates;
@property (nonatomic) NSSet * folderStates;
@property (nonatomic) NSSet * attachmentStates;


+ (BOOL)isUbiquityKeychainIdentifier:(NSString *)keychainIdentifier;
+ (BOOL)isDropboxKeychainIdentifier:(NSString *)keychainIdentifier;
+ (BOOL)isWiFiKeychainIdentifier:(NSString *)keychainIdentifier;

- (BOOL)importOnly;
- (BOOL)isWiFiSyncSource;


- (OPSyncState *)syncStateForItemUUID:(NSString *)uuid;
- (OPSyncState *)syncStateForFolderUUID:(NSString *)uuid;
- (OPSyncState *)syncStateForAttachmentUUID:(NSString *)uuid;

@end
